// $Id: CEmail.cpp,v 1.8 2007/02/11 02:15:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CEmail.hpp"
using Exponent::Host::CEmail;

#ifdef WIN32
	#include <mapi.h>
	#include "CDLLLoader.hpp"
	#include "CFileManager.hpp"
	#include "CDriveInformation.hpp"

	using Exponent::Host::CDriveInformation;
	using Exponent::Host::CFileManager;
	using Exponent::Host::CDLLLoader;

	/** @cond */
	typedef ULONG (FAR PASCAL *MAPIFUNC) (LHANDLE lhSession, ULONG ulUIParam, lpMapiMessage lpMessage, FLAGS flFlags, ULONG ulReserved);
	/** @endcond */
#else
	// ?
#endif

//	===========================================================================
bool CEmail::sendEmail(const SEmailDescription &email)
{
#ifdef WIN32

	// Now we create the message, its attatchments and the recipient
	MapiMessage message;
	MapiRecipDesc recipient;
	MapiFileDesc *descriptions = NULL;

	// Zero them
	memset(&message,   0, sizeof(MapiMessage));
	memset(&recipient, 0, sizeof(MapiRecipDesc));

	// Store the pointers
	message.lpFiles      = descriptions;
	message.lpRecips     = &recipient;
	message.nRecipCount  = 1;
	message.nFileCount   = 0;

	// Setup the email address
	CString emailAddress = "SMTP:";
	emailAddress.appendString(email.m_recipient);

	// Setup the recipient array
	recipient.ulReserved   = 0;
	recipient.ulRecipClass = MAPI_TO;
	recipient.lpszName     = (LPSTR)email.m_recipientDisplayName.getString();			// WHY IN THE FUCK ARE THESES NOT LPCSTR M$?????
	recipient.lpszAddress  = (LPSTR)emailAddress.getString();

	// Construct the basics
	message.lpszSubject  = (LPSTR)email.m_subject.getString();
	message.lpszNoteText = (LPSTR)email.m_messageBody.getString();

	// Atttatchments
	if (email.m_attatchments.getArraySize() > 0)
	{
		// Create the descritioin array
		descriptions = new MapiFileDesc[email.m_attatchments.getArraySize()];

		// We keep a count of the attatchments we create
		message.nFileCount = 0;

		// Now we go through and fill in the descriptions
		for (long i = 0; i < email.m_attatchments.getArraySize(); i++)
		{
			// Get the file info
			const CFileInformation *info = email.m_attatchments.constElementAtIndex(i);

			// Check that its valid
			if (info == NULL)
			{
				continue;
			}

			// zero the description
			memset(&descriptions[message.nFileCount], 0, sizeof(MapiFileDesc));

			// Then it exists and its one that we would want
			descriptions[message.nFileCount].nPosition    = (ULONG)-1;
			descriptions[message.nFileCount].lpszPathName = (LPSTR)info->getFullPath().getString();
			descriptions[message.nFileCount].lpszFileName = (LPSTR)info->getFullPath().getString();

			// We have added a description
			message.nFileCount++;
		}
	}

	// Load the DLL
	CSystemString windowsPath;
	CDriveInformation::getWindowsFolder(windowsPath);
	windowsPath.appendPath("System32\\mapi32.dll");

	// And try to send
	try
	{
		// Load the dll
		CDLLLoader mapiDLL(windowsPath);

		// Get the send amil function
		MAPIFUNC sendMail = (MAPIFUNC)mapiDLL.getFunction("MAPISendMail");

		// Check its valid
		if (sendMail == NULL)
		{
			// If we have them, delete the descriptions
			if (email.m_attatchments.getArraySize() > 0)
			{
				FREE_ARRAY_POINTER(descriptions);
			}

			// We are failed! :(
			return false;
		}

		// Now we actually want to send the email...
		int result = sendMail(0, NULL, &message, (email.m_sendAutomatically) ? 0 : MAPI_LOGON_UI | MAPI_DIALOG, 0);
		bool valid = (result == SUCCESS_SUCCESS);

		// If we have them, delete the descriptions
		if (email.m_attatchments.getArraySize() > 0)
		{
			FREE_ARRAY_POINTER(descriptions);
		}

		// Did it suceed???
		return valid;
	}
	catch(...)
	{
		return false;
	}
#else

	// Construct the message
	CString message = "mailto:";
	message.appendString(email.m_recipient);
	message.appendString("?subject=");
	message.appendString(email.m_subject);
	message.appendString("&body=");
	message.appendString(email.m_messageBody);

	// Construct the URL
	CFURLRef url = CFURLCreateWithBytes(NULL, (const UInt8 *)message.getString(), message.getNumberOfCharacters() * sizeof(char), kCFStringEncodingASCII, NULL);

	// Check its valid
	if (url == NULL)
	{
		return false;
	}

	// Try and open the url
	bool valid = (LSOpenCFURLRef(url, NULL) == noErr);

	// Release the old url
    CFRelease(url);

	// Done :)
	return valid;
#endif
}